<?php
session_start();

// Initialize cart: ['id' => quantity]
if(!isset($_SESSION['cart'])) {
    $_SESSION['cart'] = [];
}

// Sample products (id => ['name','price','image'])
$product = [
    2 => ["name" => "Sunset", "price" => 100, "image" => "images/sunset.jpg"],
    3 => ["name" => "Running Horse", "price" => 150, "image" => "images/horse.jpg"],
    4 => ["name" => "Mountain", "price" => 200, "image" => "images/mountain.jpg"]
];

// Handle Add to Cart
if(isset($_GET['action']) && $_GET['action'] == 'add' && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    $_SESSION['cart'][$id] = isset($_SESSION['cart'][$id]) ? $_SESSION['cart'][$id]+1 : 1;
}

// Handle Remove from Cart
if(isset($_GET['action']) && $_GET['action'] == 'remove' && isset($_GET['id'])) {
    $id = (int)$_GET['id'];
    unset($_SESSION['cart'][$id]);
}

// Handle Clear Cart
if(isset($_GET['action']) && $_GET['action'] == 'clear') {
    $_SESSION['cart'] = [];
}

// Handle Buy Now (just show total and clear)
if(isset($_GET['action']) && $_GET['action'] == 'buy') {
    if(!empty($_SESSION['cart'])) {
        $total_price = 0;
        $total_items = 0;
        foreach($_SESSION['cart'] as $id => $qty) {
            $total_items += $qty;
            $total_price += $products[$id]['price'] * $qty;
        }
        $_SESSION['cart'] = []; // clear cart
        $message = "Purchase Successful! Total Items: $total_items, Total Price: ₹$total_price";
    } else {
        $message = "Cart is empty!";
    }
}

// Calculate current cart totals
$cart_total_items = array_sum($_SESSION['cart']);
$cart_total_price = 0;
foreach($_SESSION['cart'] as $id => $qty) {
    $cart_total_price += $product[$id]['price'] * $qty;
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Simple Cart</title>
    <style>
        .product { display:inline-block; margin:20px; text-align:center; }
        .product img { width:150px; height:100px; display:block; margin-bottom:5px; }
        .cart { margin-top:30px; border-top:1px solid #ccc; padding-top:20px; }
        .cart ul { list-style:none; padding:0; }
        .cart li { margin-bottom:10px; }
        .btn { padding:5px 10px; text-decoration:none; background:#28a745; color:#fff; border-radius:3px; margin:2px; }
        .btn.remove { background:#dc3545; }
        .btn.clear { background:#6c757d; }
    </style>
</head>
<body>

<h2>Products</h2>
<?php foreach($product as $id => $product): ?>
    <div class="product">
        <img src="<?php echo $product['image']; ?>" alt="<?php echo $product['name']; ?>">
        <strong><?php echo $product['name']; ?></strong><br>
        Price: ₹<?php echo $product['price']; ?><br>
        <a class="btn" href="cart.php?action=add&id=<?php echo $id; ?>">Add to Cart</a>
        <a class="btn" href="cart.php?action=buy">Buy Now</a>
    </div>
<?php endforeach; ?>

<div class="cart">
    <h3>Cart (<?php echo $cart_total_items; ?> items)</h3>

    <?php if(isset($message)) echo "<p style='color:green;'>$message</p>"; ?>

    <?php if(!empty($_SESSION['cart'])): ?>
        <ul>
        <?php foreach($_SESSION['cart'] as $id => $qty): ?>
            <li>
                <?php echo $product[$id]['name']; ?> - ₹<?php echo $product[$id]['price']; ?> x <?php echo $qty; ?> = ₹<?php echo $product[$id]['price']*$qty; ?>
                <a class="btn remove" href="cart.php?action=remove&id=<?php echo $id; ?>">Remove</a>
            </li>
        <?php endforeach; ?>
        </ul>
        <p><strong>Total Price: ₹<?php echo $cart_total_price; ?></strong></p>
        <a class="btn clear" href="cart.php?action=clear">Clear Cart</a>
    <?php else: ?>
        <p>Cart is empty.</p>
    <?php endif; ?>
</div>

</body>
</html>
